/*
 * Decompiled with CFR 0.152.
 */
package fun.xuewei.codediary;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import fun.xuewei.codediary.CodeDiarySettings;
import fun.xuewei.codediary.CommitInfo;
import fun.xuewei.codediary.GenerateApiClient;
import fun.xuewei.codediary.GitTodayCommitsLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;

public class CodeDiaryPanel
extends SimpleToolWindowPanel {
    private static final String KEY_COMMIT_INFO = "commitInfo";
    private static final int COL_HASH_WIDTH = 58;
    private static final int COL_TIME_WIDTH = 120;
    private static final int HOVER_DELAY_MS = 400;
    private static final int HOVER_HIDE_DELAY_MS = 300;
    private final Project project;
    private final JPanel commitListPanel;
    private final JScrollPane listScrollPane;
    private final JSpinner startDateSpinner;
    private final JSpinner endDateSpinner;
    private final JButton queryButton;
    private final JComboBox<String> rangeCombo;
    private final JButton generateButton;
    private JWindow hoverDetailWindow;
    private Timer hoverShowTimer;
    private Timer hoverHideTimer;
    private JPanel hoverRow;

    public CodeDiaryPanel(Project project) {
        super(false, true);
        this.project = project;
        this.commitListPanel = new JPanel();
        this.listScrollPane = new JBScrollPane((Component)this.commitListPanel);
        this.startDateSpinner = CodeDiaryPanel.createDateSpinner();
        this.endDateSpinner = CodeDiaryPanel.createDateSpinner();
        this.queryButton = new JButton("\u67e5\u8be2");
        this.rangeCombo = new JComboBox<String>(new String[]{"\u4eca\u5929", "\u6700\u8fd13\u5929", "\u6700\u8fd17\u5929", "\u6700\u8fd130\u5929", "\u6700\u8fd190\u5929"});
        this.generateButton = new JButton("\u751f\u6210");
        this.initPanel();
    }

    private static JSpinner createDateSpinner() {
        JSpinner spinner = new JSpinner(new SpinnerDateModel());
        JSpinner.DateEditor editor = new JSpinner.DateEditor(spinner, "yyyy-MM-dd");
        spinner.setEditor(editor);
        return spinner;
    }

    private void initPanel() {
        JPanel content = new JPanel(new BorderLayout(0, JBUI.scale((int)8)));
        content.setBorder(JBUI.Borders.empty((int)10));
        JPanel top = new JPanel(new FlowLayout(0, JBUI.scale((int)4), JBUI.scale((int)4)));
        top.add(new JLabel("\u5f00\u59cb:"));
        top.add(this.startDateSpinner);
        top.add(new JLabel("\u7ed3\u675f:"));
        top.add(this.endDateSpinner);
        this.queryButton.addActionListener(e -> this.loadCommitsAsync());
        top.add(this.queryButton);
        this.rangeCombo.setSelectedIndex(0);
        this.rangeCombo.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.setDateRangeFromCombo();
            }
        });
        top.add(this.rangeCombo);
        content.add((Component)top, "North");
        this.commitListPanel.setLayout(new BoxLayout(this.commitListPanel, 1));
        this.listScrollPane.setPreferredSize(new Dimension(0, 220));
        content.add((Component)this.listScrollPane, "Center");
        JPanel bottom = new JPanel(new FlowLayout(0));
        this.generateButton.addActionListener(e -> this.onGenerate());
        bottom.add(this.generateButton);
        JButton settingsBtn = new JButton(AllIcons.General.Gear);
        settingsBtn.setToolTipText("\u914d\u7f6e");
        settingsBtn.setBorderPainted(false);
        settingsBtn.setFocusPainted(false);
        settingsBtn.setContentAreaFilled(false);
        int iconSize = JBUI.scale((int)22);
        settingsBtn.setPreferredSize(new Dimension(iconSize, iconSize));
        settingsBtn.setMinimumSize(new Dimension(iconSize, iconSize));
        settingsBtn.addActionListener(e -> this.showConfigDialog());
        bottom.add(settingsBtn);
        content.add((Component)bottom, "South");
        this.setContent(content);
        this.setDefaultDateRange();
    }

    private void setDefaultDateRange() {
        this.rangeCombo.setSelectedIndex(0);
        this.setDateRangeFromCombo();
    }

    private void setDateRangeFromCombo() {
        int days = this.getDaysFromRangeCombo();
        LocalDate today = LocalDate.now();
        LocalDate start = today.minusDays(days);
        this.startDateSpinner.setValue(Date.from(start.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        this.endDateSpinner.setValue(Date.from(today.atStartOfDay(ZoneId.systemDefault()).toInstant()));
        this.loadCommitsAsync();
    }

    private int getDaysFromRangeCombo() {
        switch (this.rangeCombo.getSelectedIndex()) {
            case 1: {
                return 3;
            }
            case 2: {
                return 7;
            }
            case 3: {
                return 30;
            }
            case 4: {
                return 90;
            }
        }
        return 0;
    }

    private void loadCommitsAsync() {
        Date end;
        Date start = (Date)this.startDateSpinner.getValue();
        if (start.after(end = (Date)this.endDateSpinner.getValue())) {
            JOptionPane.showMessageDialog((Component)((Object)this), "\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", "\u63d0\u793a", 2);
            return;
        }
        long startMillis = start.getTime();
        long endMillis = CodeDiaryPanel.endOfDay(end);
        this.commitListPanel.removeAll();
        this.commitListPanel.add(new JLabel("\u52a0\u8f7d\u4e2d..."));
        this.commitListPanel.revalidate();
        this.commitListPanel.repaint();
        this.listScrollPane.revalidate();
        this.listScrollPane.repaint();
        this.queryButton.setEnabled(false);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List<CommitInfo> commits;
            try {
                commits = GitTodayCommitsLoader.loadCommitsForCurrentUser(this.project, startMillis, endMillis);
            }
            catch (Throwable t) {
                commits = new ArrayList<CommitInfo>();
            }
            List<CommitInfo> finalCommits = commits;
            SwingUtilities.invokeLater(() -> this.applyCommitList(finalCommits));
        });
    }

    private void applyCommitList(List<CommitInfo> commits) {
        this.commitListPanel.removeAll();
        if (commits.isEmpty()) {
            String[] hints;
            JLabel emptyHint = new JLabel("\u8be5\u65f6\u95f4\u8303\u56f4\u5185\u6682\u65e0\u63d0\u4ea4\u8bb0\u5f55");
            emptyHint.setForeground(new Color(128, 128, 128));
            this.commitListPanel.add(emptyHint);
            this.commitListPanel.add(Box.createVerticalStrut(JBUI.scale((int)8)));
            JLabel hintTitle = new JLabel("\u8bf7\u786e\u8ba4\uff1a");
            hintTitle.setForeground(new Color(128, 128, 128));
            hintTitle.setFont(hintTitle.getFont().deriveFont(11.0f));
            this.commitListPanel.add(hintTitle);
            int leftGap = JBUI.scale((int)12);
            for (String h : hints = new String[]{"\u9879\u76ee\u6839\u76ee\u5f55\u4e3a Git \u4ed3\u5e93", "\u5df2\u914d\u7f6e git user.name / user.email", "\u6240\u9009\u65e5\u671f\u5185\u6709\u60a8\u7684\u63d0\u4ea4"}) {
                JLabel line = new JLabel("  \u2022 " + h);
                line.setForeground(new Color(128, 128, 128));
                line.setFont(line.getFont().deriveFont(11.0f));
                line.setBorder(BorderFactory.createEmptyBorder(0, leftGap, 0, 0));
                this.commitListPanel.add(line);
            }
        } else {
            SimpleDateFormat timeFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            LocalDate today = LocalDate.now();
            long todayStartMillis = today.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
            long todayEndMillis = today.plusDays(1L).atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli() - 1L;
            for (CommitInfo c : commits) {
                JCheckBox check = new JCheckBox();
                check.putClientProperty(KEY_COMMIT_INFO, c);
                boolean isToday = c.getCommitTimeMillis() >= todayStartMillis && c.getCommitTimeMillis() <= todayEndMillis;
                check.setSelected(isToday);
                String subject = c.getSubject();
                JLabel hashLabel = new JLabel(c.getShortHash());
                hashLabel.setPreferredSize(new Dimension(58, 22));
                hashLabel.setMinimumSize(new Dimension(58, 22));
                JLabel timeLabel = new JLabel(timeFmt.format(new Date(c.getCommitTimeMillis())));
                timeLabel.setPreferredSize(new Dimension(120, 22));
                timeLabel.setMinimumSize(new Dimension(120, 22));
                JLabel msgLabel = new JLabel(subject != null ? subject : "");
                msgLabel.setToolTipText(subject);
                JPanel row = new JPanel(new GridBagLayout());
                row.putClientProperty(KEY_COMMIT_INFO, c);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.anchor = 17;
                gbc.insets = new Insets(1, 0, 1, 4);
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.weightx = 0.0;
                row.add((Component)check, gbc);
                gbc.gridx = 1;
                row.add((Component)hashLabel, gbc);
                gbc.gridx = 2;
                row.add((Component)timeLabel, gbc);
                gbc.gridx = 3;
                gbc.weightx = 1.0;
                gbc.fill = 2;
                row.add((Component)msgLabel, gbc);
                row.setMaximumSize(new Dimension(Integer.MAX_VALUE, 30));
                this.addRowHoverListener(row);
                this.commitListPanel.add(row);
            }
        }
        this.commitListPanel.revalidate();
        this.commitListPanel.repaint();
        this.listScrollPane.revalidate();
        this.listScrollPane.repaint();
        this.queryButton.setEnabled(true);
    }

    private void addRowHoverListener(final JPanel row) {
        MouseAdapter hoverAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                CodeDiaryPanel.this.cancelHoverHide();
                CodeDiaryPanel.this.hoverRow = row;
                if (CodeDiaryPanel.this.hoverShowTimer != null) {
                    CodeDiaryPanel.this.hoverShowTimer.stop();
                }
                CodeDiaryPanel.this.hoverShowTimer = new Timer(400, ev -> {
                    CodeDiaryPanel.this.hoverShowTimer.stop();
                    Object info = row.getClientProperty(CodeDiaryPanel.KEY_COMMIT_INFO);
                    if (info instanceof CommitInfo) {
                        CodeDiaryPanel.this.showHoverDetail(row, (CommitInfo)info);
                    }
                });
                CodeDiaryPanel.this.hoverShowTimer.setRepeats(false);
                CodeDiaryPanel.this.hoverShowTimer.start();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (CodeDiaryPanel.this.hoverShowTimer != null) {
                    CodeDiaryPanel.this.hoverShowTimer.stop();
                    CodeDiaryPanel.this.hoverShowTimer = null;
                }
                CodeDiaryPanel.this.hoverRow = null;
                CodeDiaryPanel.this.scheduleHoverHide();
            }
        };
        MouseAdapter clickAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getSource() instanceof JCheckBox) {
                    return;
                }
                for (Component comp : row.getComponents()) {
                    JCheckBox check;
                    if (!(comp instanceof JCheckBox)) continue;
                    check.setSelected(!(check = (JCheckBox)comp).isSelected());
                    break;
                }
            }
        };
        row.addMouseListener(hoverAdapter);
        row.addMouseListener(clickAdapter);
        Component[] comps = row.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            comps[i].addMouseListener(clickAdapter);
            if (i != 3) continue;
            comps[i].addMouseListener(hoverAdapter);
        }
    }

    private void cancelHoverHide() {
        if (this.hoverHideTimer != null) {
            this.hoverHideTimer.stop();
            this.hoverHideTimer = null;
        }
    }

    private void scheduleHoverHide() {
        this.cancelHoverHide();
        this.hoverHideTimer = new Timer(300, ev -> {
            this.hoverHideTimer.stop();
            this.hideHoverDetail();
        });
        this.hoverHideTimer.setRepeats(false);
        this.hoverHideTimer.start();
    }

    private void showHoverDetail(JPanel row, CommitInfo c) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            String detail = GitTodayCommitsLoader.getCommitDetail(this.project, c.getHash());
            SwingUtilities.invokeLater(() -> {
                if (this.hoverRow != row) {
                    return;
                }
                this.hideHoverDetail();
                JTextArea area = new JTextArea(detail);
                area.setEditable(false);
                area.setLineWrap(true);
                area.setWrapStyleWord(true);
                area.setRows(10);
                area.setMargin(new Insets(6, 8, 6, 8));
                area.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        CodeDiaryPanel.this.cancelHoverHide();
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        CodeDiaryPanel.this.scheduleHoverHide();
                    }
                });
                JScrollPane scroll = new JScrollPane(area);
                scroll.setPreferredSize(new Dimension(420, 220));
                scroll.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        CodeDiaryPanel.this.cancelHoverHide();
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        CodeDiaryPanel.this.scheduleHoverHide();
                    }
                });
                this.hoverDetailWindow = new JWindow(SwingUtilities.getWindowAncestor((Component)((Object)this)));
                this.hoverDetailWindow.getContentPane().add(scroll);
                this.hoverDetailWindow.pack();
                Point rowOnScreen = row.getLocationOnScreen();
                this.hoverDetailWindow.setLocation(rowOnScreen.x, rowOnScreen.y + row.getHeight() + 2);
                this.hoverDetailWindow.setVisible(true);
            });
        });
    }

    private void hideHoverDetail() {
        if (this.hoverDetailWindow != null) {
            this.hoverDetailWindow.setVisible(false);
            this.hoverDetailWindow.dispose();
            this.hoverDetailWindow = null;
        }
    }

    private static long endOfDay(Date date) {
        LocalDate d = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return d.atTime(23, 59, 59, 999000000).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    private void showConfigDialog() {
        CodeDiarySettings settings = CodeDiarySettings.getInstance();
        JPanel configPanel = new JPanel(new BorderLayout(JBUI.scale((int)8), JBUI.scale((int)8)));
        configPanel.setBorder(JBUI.Borders.empty((int)16));
        JLabel formatLabel = new JLabel("\u65e5\u62a5\u683c\u5f0f");
        JLabel formatHint = new JLabel("\u53ef\u914d\u7f6e\u751f\u6210\u65e5\u62a5\u7684\u683c\u5f0f\u6a21\u677f\uff0c\u4f9b AI \u6a21\u4eff\u3002");
        formatHint.setForeground(new Color(128, 128, 128));
        formatHint.setFont(formatHint.getFont().deriveFont(11.0f));
        JTextArea formatArea = new JTextArea(6, 40);
        formatArea.setLineWrap(true);
        formatArea.setWrapStyleWord(true);
        formatArea.setMargin(new Insets(6, 8, 6, 8));
        formatArea.setText(settings.getReportFormat() != null ? settings.getReportFormat() : "");
        JLabel otherLabel = new JLabel("\u5176\u4ed6\u5185\u5bb9");
        JLabel otherHint = new JLabel("\u4efb\u4f55\u60f3\u8981\u8865\u5145\u544a\u8bc9 AI \u7684\u5185\u5bb9\u3002");
        otherHint.setForeground(new Color(128, 128, 128));
        otherHint.setFont(otherHint.getFont().deriveFont(11.0f));
        JTextArea otherArea = new JTextArea(4, 40);
        otherArea.setLineWrap(true);
        otherArea.setWrapStyleWord(true);
        otherArea.setMargin(new Insets(6, 8, 6, 8));
        otherArea.setText(settings.getOtherContent() != null ? settings.getOtherContent() : "");
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        int gap = JBUI.scale((int)12);
        JPanel formatBlock = new JPanel(new BorderLayout(0, JBUI.scale((int)4)));
        formatBlock.add((Component)formatLabel, "North");
        formatBlock.add((Component)formatHint, "Center");
        content.add(formatBlock);
        content.add(Box.createVerticalStrut(JBUI.scale((int)4)));
        content.add((Component)new JBScrollPane((Component)formatArea));
        content.add(Box.createVerticalStrut(gap));
        JPanel otherBlock = new JPanel(new BorderLayout(0, JBUI.scale((int)4)));
        otherBlock.add((Component)otherLabel, "North");
        otherBlock.add((Component)otherHint, "Center");
        content.add(otherBlock);
        content.add(Box.createVerticalStrut(JBUI.scale((int)4)));
        content.add((Component)new JBScrollPane((Component)otherArea));
        JBScrollPane contentScroll = new JBScrollPane((Component)content);
        contentScroll.setBorder((Border)JBUI.Borders.empty());
        configPanel.add((Component)contentScroll, "Center");
        JButton saveBtn = new JButton("\u4fdd\u5b58");
        JButton closeBtn = new JButton("\u5173\u95ed");
        JPanel south = new JPanel(new FlowLayout(2, JBUI.scale((int)8), 0));
        south.add(saveBtn);
        south.add(closeBtn);
        configPanel.add((Component)south, "South");
        JDialog dialog = new JDialog(SwingUtilities.getWindowAncestor((Component)((Object)this)), "\u914d\u7f6e CodeDiary", Dialog.ModalityType.APPLICATION_MODAL);
        dialog.getContentPane().add(configPanel);
        dialog.setMinimumSize(new Dimension(420, 420));
        saveBtn.addActionListener(e -> {
            settings.setReportFormat(formatArea.getText().trim());
            settings.setOtherContent(otherArea.getText().trim());
            dialog.dispose();
        });
        closeBtn.addActionListener(e -> dialog.dispose());
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
    }

    private void onGenerate() {
        ArrayList<CommitInfo> selected = new ArrayList<CommitInfo>();
        block0: for (Component comp : this.commitListPanel.getComponents()) {
            if (!(comp instanceof JPanel)) continue;
            JPanel row = (JPanel)comp;
            for (Component c : row.getComponents()) {
                Object info;
                if (!(c instanceof JCheckBox)) continue;
                JCheckBox check = (JCheckBox)c;
                if (!check.isSelected() || !((info = check.getClientProperty(KEY_COMMIT_INFO)) instanceof CommitInfo)) continue block0;
                selected.add((CommitInfo)info);
                continue block0;
            }
        }
        if (selected.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "\u8bf7\u81f3\u5c11\u52fe\u9009\u4e00\u6761\u63d0\u4ea4\u8bb0\u5f55\u3002", "\u63d0\u793a", 1);
            return;
        }
        CodeDiarySettings settings = CodeDiarySettings.getInstance();
        String machineCode = settings.getMachineCode();
        if (machineCode == null || machineCode.isEmpty()) {
            machineCode = UUID.randomUUID().toString();
            settings.setMachineCode(machineCode);
        }
        ArrayList<String> commits = new ArrayList<String>();
        SimpleDateFormat timeFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        for (CommitInfo c : selected) {
            String detail = GitTodayCommitsLoader.getCommitDetail(this.project, c.getHash());
            commits.add((String)(detail != null ? detail : c.getShortHash() + " " + timeFmt.format(new Date(c.getCommitTimeMillis())) + " " + (c.getSubject() != null ? c.getSubject() : "")));
        }
        GenerateApiClient.GenerateRequest req = new GenerateApiClient.GenerateRequest();
        req.machineCode = machineCode;
        req.clientVersion = "26.01.30";
        req.projectName = this.project.getName() != null ? this.project.getName() : "";
        req.commits = commits;
        req.reportFormat = settings.getReportFormat() != null ? settings.getReportFormat() : "";
        req.otherContent = settings.getOtherContent() != null ? settings.getOtherContent() : "";
        this.generateButton.setEnabled(false);
        this.generateButton.setText("\u751f\u6210\u4e2d...");
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Object result;
            try {
                result = GenerateApiClient.generate(req);
            }
            catch (Throwable t) {
                result = "\u751f\u6210\u5931\u8d25: " + (t.getMessage() != null ? t.getMessage() : t.getClass().getSimpleName());
            }
            String finalResult = result;
            SwingUtilities.invokeLater(() -> {
                this.generateButton.setText("\u751f\u6210");
                this.generateButton.setEnabled(true);
                this.showGenerateResultDialog(finalResult);
            });
        });
    }

    private void showGenerateResultDialog(String fullText) {
        JTextArea area = new JTextArea(fullText);
        area.setEditable(true);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setMargin(new Insets(8, 10, 8, 10));
        JBScrollPane scroll = new JBScrollPane((Component)area);
        scroll.setPreferredSize(new Dimension(520, 360));
        JButton copyBtn = new JButton("\u590d\u5236");
        JButton closeBtn = new JButton("\u5173\u95ed");
        JPanel south = new JPanel(new FlowLayout(2, JBUI.scale((int)8), 0));
        south.add(copyBtn);
        south.add(closeBtn);
        JPanel content = new JPanel(new BorderLayout(JBUI.scale((int)8), JBUI.scale((int)8)));
        content.setBorder(JBUI.Borders.empty((int)12));
        content.add((Component)scroll, "Center");
        content.add((Component)south, "South");
        JDialog dialog = new JDialog(SwingUtilities.getWindowAncestor((Component)((Object)this)), "\u751f\u6210\u5185\u5bb9", Dialog.ModalityType.APPLICATION_MODAL);
        dialog.getContentPane().add(content);
        copyBtn.addActionListener(e -> {
            try {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(area.getText()), null);
                JOptionPane.showMessageDialog(dialog, "\u590d\u5236\u6210\u529f\u3002", "\u63d0\u793a", -1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        closeBtn.addActionListener(e -> dialog.dispose());
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
    }
}

