/*
 * Decompiled with CFR 0.152.
 */
package fun.xuewei.codediary;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;

public final class GenerateApiClient {
    private static final String BASE_URL = "https://code-diary.xuewei.fun/CodeDiary/generate";
    private static final Duration REQUEST_TIMEOUT = Duration.ofSeconds(60L);

    public static String generate(GenerateRequest req) throws Exception {
        String json = GenerateApiClient.buildRequestBody(req);
        HttpClient client = HttpClient.newBuilder().connectTimeout(REQUEST_TIMEOUT).build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(BASE_URL)).header("Content-Type", "application/json; charset=UTF-8").timeout(REQUEST_TIMEOUT).POST(HttpRequest.BodyPublishers.ofString(json, StandardCharsets.UTF_8)).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
        String body = response.body();
        int statusCode = response.statusCode();
        if (statusCode < 200 || statusCode >= 300) {
            throw new RuntimeException("\u8bf7\u6c42\u5931\u8d25: HTTP " + statusCode + (String)(body != null && !body.isEmpty() ? " " + body : ""));
        }
        return GenerateApiClient.parseResponse(body);
    }

    private static String parseResponse(String body) {
        if (body == null || body.isEmpty()) {
            return "";
        }
        if (!(body = body.trim()).startsWith("{")) {
            return body;
        }
        String code = GenerateApiClient.extractJsonStringValue(body, "code");
        if (code != null && !"OK".equals(code.trim())) {
            String message = GenerateApiClient.extractJsonStringValue(body, "message");
            return "\u751f\u6210\u5931\u8d25\uff1a" + (message != null && !message.isEmpty() ? message : code);
        }
        String data = GenerateApiClient.extractJsonStringValue(body, "data");
        return data != null ? data : body;
    }

    private static String extractJsonStringValue(String body, String key) {
        String search = "\"" + key + "\"";
        int idx = body.indexOf(search);
        if (idx == -1) {
            return null;
        }
        int colon = body.indexOf(58, idx);
        if (colon == -1) {
            return null;
        }
        int start = body.indexOf(34, colon + 1);
        if (start == -1) {
            return null;
        }
        StringBuilder value = new StringBuilder();
        for (int i = ++start; i < body.length(); ++i) {
            char c = body.charAt(i);
            if (c == '\\' && i + 1 < body.length()) {
                char next = body.charAt(i + 1);
                if (next == '\"') {
                    value.append('\"');
                    ++i;
                    continue;
                }
                if (next == 'n') {
                    value.append('\n');
                    ++i;
                    continue;
                }
                if (next == 'r') {
                    value.append('\r');
                    ++i;
                    continue;
                }
                if (next == 't') {
                    value.append('\t');
                    ++i;
                    continue;
                }
                if (next == '\\') {
                    value.append('\\');
                    ++i;
                    continue;
                }
            }
            if (c == '\"') break;
            value.append(c);
        }
        return value.toString();
    }

    private static String buildRequestBody(GenerateRequest req) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"machineCode\":").append(GenerateApiClient.escapeJson(req.machineCode));
        sb.append(",\"clientVersion\":").append(GenerateApiClient.escapeJson(req.clientVersion));
        sb.append(",\"projectName\":").append(GenerateApiClient.escapeJson(req.projectName != null ? req.projectName : ""));
        sb.append(",\"commits\":[");
        if (req.commits != null) {
            for (int i = 0; i < req.commits.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(GenerateApiClient.escapeJson(req.commits.get(i)));
            }
        }
        sb.append("]");
        sb.append(",\"reportFormat\":").append(GenerateApiClient.escapeJson(req.reportFormat != null ? req.reportFormat : ""));
        sb.append(",\"otherContent\":").append(GenerateApiClient.escapeJson(req.otherContent != null ? req.otherContent : ""));
        sb.append("}");
        return sb.toString();
    }

    private static String escapeJson(String s) {
        if (s == null) {
            return "\"\"";
        }
        StringBuilder sb = new StringBuilder(s.length() + 8);
        sb.append('\"');
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block7;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block7;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block7;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block7;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static class GenerateRequest {
        public String machineCode;
        public String clientVersion;
        public String projectName;
        public List<String> commits;
        public String reportFormat;
        public String otherContent;
    }
}

